cd "Z:\work\Baze\SILC_Serbia\2019"

use p-file, clear

****************************************
* income from depenedent employment ****
****************************************
* generate monthly net income
* calculate total months worked in the year as an employee
egen tot_mont = rowtotal (pl073 pl074)
recode tot_mont (0=.)
tab tot_mont
* given that most of the workers worked for 12 months we impute 12 months where the information is not available
replace tot_mont = 12 if tot_mont==. & py010n !=0
* no working months if there is no income from dependent employment
replace tot_mont = . if py010n == 0
label var tot_mont "Total months employee "

/*
gen tax_silc = py010g - py010n
gen tax_ratio = py010g / py010n
tab tax_silc 
*/
* calculate monthly income
gen yee_n_m = py010n / tot_mont
label var yee_n_m "Income employee - net"
recode py010n (0=.)
sum py010n tot_mont yee_n_m

sum yee_n_m, d

* informal income
*gen yee_n_m_inf = yee_n_m if inf == 1
*replace yee_n_m = . if inf == 1

* generate gross monthly income 1 (base for tax and SSC calculation)
gen  		yee_g_m = (yee_n_m + 3230.279)/0.9 ///
					   if yee_n_m<18299 
replace 	yee_g_m = (yee_n_m - 1530)/0.701 ///
					   if yee_n_m>=18299 & yee_n_m<241079
replace 	yee_g_m = (yee_n_m + 69533.275)/0.9	///
					   if yee_n_m>=241079 & yee_n_m!=.
label var yee_g_m "Income employee - gross"
							
* generate gross monthly income 2 (includes total taxes and SSC)
gen 		yee_g2_m = yee_n_m + 0.1*yee_g_m + 7332.7305 ///
					   if yee_n_m<18299 
replace 	yee_g2_m = yee_n_m + 0.4705*yee_g_m - 1530 ///
					   if yee_n_m>=18299 & yee_n_m<241079
replace 	yee_g2_m = yee_n_m + 0.1*yee_g_m + 125079.1125 ///
					   if yee_n_m>=241079 & yee_n_m!=.
label var yee_g2_m "Income employee - gross2 (total tax and SSC)"

sum yee_n_m yee_g_m yee_g2_m

keep idhh idperson tot_mont - yee_g2_m

save income, replace
